﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CSharpEloPubInterface;

namespace CSharpEloPubInterface
{
    public partial class Form1 : Form
    {
        public UInt32 m_nScrNo = 0;
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            /*
            TOUCH_POINT tpxy = new TOUCH_POINT();
            Int32 xlated = 1;
            GETPOINTS_CODE getCode = GETPOINTS_CODE.ReturnImmediately;
            UInt32 pScrNo = new UInt32();
            EloPubIf.EloGetTouch(ref tpxy, xlated, getCode, ref pScrNo);
            */
            int nRet = 0;            

            BEEP psndVal = new BEEP();
            nRet = EloPubIf.EloSetBeep(ref psndVal, m_nScrNo);
            psndVal.BeepFlag = checkBoxBeepOnTouch.Checked?1:0;
            psndVal.BeepFreq = (uint)trackToneBar.Value;
            psndVal.BeepTime = (uint)trackDurationBar.Value;
            psndVal.UseExternalSpeaker = radioBtnExtSpeaker.Checked?1:0;
            nRet = EloPubIf.EloSetBeep(ref psndVal, m_nScrNo);
            trackToneBar.Enabled = true;
            trackDurationBar.Enabled = true;            
            trackToneBar.Invalidate();
            trackDurationBar.Invalidate();

            Int16 nMouseMode = 6;
            if (radioBtnMouseEmu.Checked)
                nMouseMode = 6;
            else if (radioBtnCORelease.Checked)
                nMouseMode = 1;
            else if (radioBtnCOTouch.Checked)
                nMouseMode = 0;
            nRet = EloPubIf.EloSetMouseMode(nMouseMode, m_nScrNo);

            DRAG_DELAY pDragDelay = new DRAG_DELAY();
            pDragDelay.DragDelay = (uint) trackDragDelayBar.Value;;
            nRet = EloPubIf.EloSetDragDelay(ref pDragDelay, m_nScrNo);

            UNTOUCH_TIMEOUT pUTimeout = new UNTOUCH_TIMEOUT();
            pUTimeout.TimeOut =Convert.ToUInt32(textBoxUntouchTimeout.Text, 10);
            nRet = EloPubIf.EloSetUntouchTimeout(ref pUTimeout, m_nScrNo);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            textBoxScreenIdx.Clear();
            textBoxScreenIdx.Focus();
            textBoxScreenIdx.AppendText("0");

            int nRet = 0;
            Int32 count = new Int32();
            UInt32[] dwMonNo = new UInt32[256];
            nRet = EloPubIf.EloGetScreenInfo(dwMonNo, ref count);
            textBoxScreenCount.Clear();
            textBoxScreenCount.AppendText(count.ToString());

            m_nScrNo = Convert.ToUInt32(textBoxScreenIdx.Text, 10);
            DRAG_DELAY pDragDelay = new DRAG_DELAY();
            nRet = EloPubIf.EloGetDragDelay(ref pDragDelay, m_nScrNo);
            trackDragDelayBar.Value = (int)pDragDelay.DragDelay;

            BEEP psndVal = new BEEP();
            nRet = EloPubIf.EloGetBeep(ref psndVal, m_nScrNo);

            checkBoxBeepOnTouch.Checked = !(psndVal.BeepFlag == 0);
            trackToneBar.Value = (int) psndVal.BeepFreq;
            trackDurationBar.Value = (int) psndVal.BeepTime;

            if (psndVal.UseExternalSpeaker==0)
                radioBtonMothSpeaker.Select();
            else
                radioBtnExtSpeaker.Select();

            Int16 pwMode = new Int16();
            EloPubIf.EloGetMouseMode(ref pwMode, m_nScrNo);

            switch (pwMode)
            {
                case 6:
                    radioBtnMouseEmu.Select();
                    break;
                case 1:
                    radioBtnCORelease.Select();
                    break;
                case 0:
                    radioBtnCOTouch.Select();
                    break;

                default:
                    radioBtnCOTouch.Select();
                    break;
            }

            UNTOUCH_TIMEOUT pUTimeout = new UNTOUCH_TIMEOUT();
            nRet = EloPubIf.EloGetUntouchTimeout(ref pUTimeout, m_nScrNo);
            textBoxUntouchTimeout.Clear();
            textBoxUntouchTimeout.AppendText((string)pUTimeout.TimeOut.ToString());

        }

        private void textBoxScreenIdx_TextChanged(object sender, EventArgs e)
        {
            m_nScrNo = Convert.ToUInt32(textBoxScreenIdx.Text, 10);
        }

        private void checkBoxBeepOnTouch_CheckedChanged(object sender, EventArgs e)
        {
            UInt32 m_nScrNo = 0;
            int nRet = 0;
            BEEP psndVal = new BEEP();
            psndVal.BeepFlag = checkBoxBeepOnTouch.Checked ? 1 : 0;
            if (!checkBoxBeepOnTouch.Checked)
            {
                trackToneBar.Enabled = false;
                trackDurationBar.Enabled = false;
            }
            else
            {            
                nRet = EloPubIf.EloGetBeep(ref psndVal, m_nScrNo);
                trackToneBar.Value = (int)psndVal.BeepFreq;
                trackDurationBar.Value = (int)psndVal.BeepTime;
                trackToneBar.Enabled = true;
                trackDurationBar.Enabled = true;
            }
            checkBoxBeepOnTouch.Invalidate();
            trackToneBar.Invalidate();
            trackDurationBar.Invalidate();
        }
    }
}
